# -*- coding:utf-8 -*-
from django.core.management.base import BaseCommand
from django.core.cache import cache
import os
import base64
import time
import datetime
__author__ = 'Arvin'


class Command(BaseCommand):
    option_list = BaseCommand.option_list + ()
    help = "Starts Process USB Transaction ."
    args = ''
    store_path = "MoleSys/data_store/usb_att_rec/"

    def load_usb_files(self):
        if not os.path.exists(self.store_path):
            os.makedirs(self.store_path)
        files = os.listdir(self.store_path)
        if not files:
            return None, None, None
        m_fn = files[0]
        sn = m_fn.split('-')[0]
        flag = cache.get(m_fn)
        if flag == '1':
            return None, None, None
        else:
            cache.delete(m_fn)
        file_store_path = os.path.join(self.store_path, m_fn)
        try:
            with file(file_store_path, 'rb+') as fs:
                data = fs.read()
                lens = len(data)
                missing_padding = lens % 4
                data += '=' * missing_padding
                m_data = base64.decodestring(data).strip().splitlines()
            cache.set('analysis_file', m_fn)
            return file_store_path, sn, m_data
        except Exception, e:
            print e
            os.remove(file_store_path)
            return None, None, None

    def get_usb_file(self):
        from comm.att.struct.sync_models import Device, ObjectDoesNotExist
        try:
            m_store, m_sn, m_list = self.load_usb_files()
            if m_sn:
                dev = Device(m_sn).get()
                return dev, m_list, m_store
            else:
                return None, None, None
        except ObjectDoesNotExist:
            cache_file = cache.get('analysis_file')
            if cache_file:
                os.remove(os.path.join(self.store_path, cache_file))
                cache.set('analysis_file', '')
            return None, None, None
        except Exception, e:
            return None, None, None

    def save2db(self, params):
        from mysite.personnel.models.model_emp import format_pin
        from mysite.sql_utils import get_sql, p_execute, p_mutiexec
        from mysite import const
        if params:
            batch_sql = []
            for ad in params:
                ad["pin"] = format_pin(ad["pin"])
                ad["data_from"] = const.USB_COPY
                insert_sql = get_sql('sql', sqlid='insert_usb_transaction', app='iclock', params=ad)
                batch_sql.append(insert_sql)
            success, res = p_mutiexec(batch_sql)
            if not success:
                if res and res[0] == -2:
                    return False
                else:
                    for bs in batch_sql:
                        num = p_execute(bs)
                        if num is None:
                            return False
                        elif num < 0:
                            return False
            now = datetime.datetime.now()
            params = {'upload_time': now.strftime('%Y-%m-%d %H:%M:%S')}
            sync_sql = get_sql('sql', sqlid='sync_usb_transaction', app='iclock', params=params)
            update_param = {'sync_time': now.strftime('%Y-%m-%d %H:%M:%S')}
            update_sql = get_sql('sql', sqlid='update_usb_transaction_status', app='iclock', params=update_param)
            try:
                p_execute(sync_sql)
                p_execute(update_sql)
            except Exception, e:
                print e
                pass
            return True

    def line2db(self, dev, m_lines):
        from mysite.settings import APP_CONFIG
        from comm.commen_utils import normal_verify
        from ooredis import Dict
        days = APP_CONFIG.DEVICE.EXPIRED_DAYS
        now = datetime.datetime.now()
        pass_time = None
        m_result = []
        if days:
            days = int(days)
            pass_time = now + datetime.timedelta(days=-days)
        area_names = Dict('area_id_name_hash')
        _now = now.strftime("%Y-%m-%d %H:%M:%S")
        for line in m_lines:
            if not line:
                continue
            flds = line.split("\t")
            if len(flds) < 2:
                continue
            flds += ["", "", "", ""]
            pin = flds[0]
            log_time = datetime.datetime.strptime(flds[1], "%Y-%m-%d %H:%M:%S")
            if pass_time and log_time < pass_time:
                continue
            device_alias = dev.alias
            device_area_name = area_names.get(dev.area)
            if device_alias:
                device_alias = u"{0}".format(device_alias).replace("'", "''")
            if device_area_name:
                device_area_name = u"{0}".format(device_area_name).replace("'", "''")
            _record = {
                'pin': pin,
                'punch_time': log_time,
                'punch_type': flds[2],
                'verify_type': normal_verify(flds[3]),
                'work_code': flds[4],
                'dev_sn': dev.sn,
                'dev_alias': device_alias,
                'area': dev.area,
                'area_alias': device_area_name,
                'upload_time': _now,
                'sync_status': 0,
            }
            m_result.append(_record)
        rtn = True
        if m_result:
            rtn = self.save2db(m_result)
        return rtn

    def handle(self, *args, **options):

        if not os.path.exists(self.store_path):
            os.makedirs(self.store_path)
        batch_lens = 100
        while True:
            dev, lines, file_path = self.get_usb_file()
            if lines:
                lens = len(lines)
                times = lens % batch_lens == 0 and lens/batch_lens or (lens/batch_lens + 1)
                for i in range(times):
                    m_lines = lines[i*batch_lens:(i+1)*batch_lens]
                    insert_success = True
                    try:
                        while insert_success:
                            ret = self.line2db(dev, m_lines)
                            if not ret:
                                time.sleep(60*2)
                            else:
                                insert_success = False
                        time.sleep(0.1)
                    except Exception, e:
                        print e
                        break
                if file_path:
                    os.remove(file_path)
                else:
                    cache_file = cache.get('analysis_file')
                    if cache_file:
                        os.remove(os.path.join(self.store_path, cache_file))
                cache.set('analysis_file', '')
            elif isinstance(lines, list):
                if file_path:
                    os.remove(file_path)
            time.sleep(1)